package main

import (
	"context"
	"fmt"
	"time"
	"ctxutil"
)

func main() {
	ctx := context.Background()
	
	err := ctxutil.DoWithTimeout(ctx, {{timeout}}*time.Second, func(ctx context.Context) error {
		// Simulate work
		time.Sleep(2 * time.Second)
		select {
		case <-ctx.Done():
			return ctx.Err()
		default:
			fmt.Println("Work completed")
			return nil
		}
	})
	
	if ctxutil.IsTimeout(err) {
		fmt.Println("Operation timed out")
	} else if err != nil {
		fmt.Printf("Error: %v\n", err)
	}
}