package main

import (
	"fmt"
	"io"
	"time"
	"httpclient"
)

func main() {
	client := httpclient.NewClient(
		{{timeout}}*time.Second,
		{{maxRetries}},
		{{retryDelay}}*time.Second,
	)
	
	headers := map[string]string{
		"Content-Type": "{{contentType}}",
		"Authorization": "Bearer {{token}}",
	}
	
	resp, err := client.Get("{{url}}", headers)
	if err != nil {
		fmt.Printf("Error: %v\n", err)
		return
	}
	defer resp.Body.Close()
	
	body, _ := io.ReadAll(resp.Body)
	fmt.Printf("Status: %d\n", resp.StatusCode)
	fmt.Printf("Body: %s\n", body)
}