package main

import (
	"context"
	"fmt"
	"time"
	"ratelimit"
)

func main() {
	limiter := ratelimit.NewRateLimiter({{rate}}, {{burst}})
	ctx := context.Background()
	
	for i := 0; i < {{requests}}; i++ {
		if limiter.Allow() {
			fmt.Printf("Request %d allowed\n", i+1)
		} else {
			fmt.Printf("Request %d rate limited\n", i+1)
			limiter.Wait(ctx)
		}
	}
}