const std = @import("std");
const array_utils = @import("array_utils.zig");

pub fn main() !void {
    var gpa = std.heap.GeneralPurposeAllocator(.{}){};
    defer _ = gpa.deinit();
    const allocator = gpa.allocator();
    
    const arr = [_]i32{ {{value1}}, {{value2}}, {{value3}}, {{value4}}, {{value5}} };
    
    // Filter even numbers
    const filtered = try array_utils.filter(i32, allocator, &arr, isEven);
    defer allocator.free(filtered);
    
    // Map to squares
    const mapped = try array_utils.map(i32, i32, allocator, &arr, square);
    defer allocator.free(mapped);
    
    // Find value
    if (array_utils.find(i32, &arr, {{searchValue}})) |index| {
        std.debug.print("Found at index: {}\n", .{index});
    }
}

fn isEven(n: i32) bool {
    return n % 2 == 0;
}

fn square(n: i32) i32 {
    return n * n;
}