const std = @import("std");
const HashMap = @import("hash_map.zig").HashMap;

pub fn main() !void {
    var gpa = std.heap.GeneralPurposeAllocator(.{}){};
    defer _ = gpa.deinit();
    const allocator = gpa.allocator();
    
    var map = HashMap(i32).init(allocator);
    defer map.deinit();
    
    try map.put("{{key1}}", {{value1}});
    try map.put("{{key2}}", {{value2}});
    try map.put("{{key3}}", {{value3}});
    
    if (map.get("{{key1}}")) |value| {
        std.debug.print("Value for '{{key1}}': {}\n", .{value});
    }
    
    std.debug.print("Size: {}\n", .{map.size()});
    
    _ = map.remove("{{deleteKey}}");
    std.debug.print("Size after remove: {}\n", .{map.size()});
}