const std = @import("std");

pub fn HashMap(comptime V: type) type {
    return struct {
        map: std.StringHashMap(V),
        allocator: std.mem.Allocator,
        
        const Self = @This();
        
        pub fn init(allocator: std.mem.Allocator) Self {
            return Self{
                .map = std.StringHashMap(V).init(allocator),
                .allocator = allocator,
            };
        }
        
        pub fn put(self: *Self, key: []const u8, value: V) !void {
            try self.map.put(key, value);
        }
        
        pub fn get(self: *const Self, key: []const u8) ?V {
            return self.map.get(key);
        }
        
        pub fn remove(self: *Self, key: []const u8) ?V {
            return self.map.fetchRemove(key);
        }
        
        pub fn contains(self: *const Self, key: []const u8) bool {
            return self.map.contains(key);
        }
        
        pub fn size(self: *const Self) usize {
            return self.map.count();
        }
        
        pub fn clear(self: *Self) void {
            self.map.clearAndFree();
        }
        
        pub fn deinit(self: *Self) void {
            self.map.deinit();
        }
    };
}