const std = @import("std");
const StringBuilder = @import("string_builder.zig").StringBuilder;

pub fn main() !void {
    var gpa = std.heap.GeneralPurposeAllocator(.{}){};
    defer _ = gpa.deinit();
    const allocator = gpa.allocator();
    
    var sb = StringBuilder.initWithCapacity(allocator, {{capacity}});
    defer sb.deinit();
    
    try sb.append("{{prefix}}");
    try sb.append(" ");
    try sb.append("{{suffix}}");
    try sb.appendChar('!');
    try sb.appendLine("{{line}}");
    
    const result = try sb.build();
    defer allocator.free(result);
    
    std.debug.print("{s}\n", .{result});
}