package main

import (
	"fmt"
	"sliceutil"
)

func main() {
	numbers := []int{{numbers}}
	
	// Filter even numbers
	even := sliceutil.Filter(numbers, func(n int) bool {
		return n%2 == 0
	})
	fmt.Println("Even:", even)
	
	// Map to squares
	squares := sliceutil.Map(numbers, func(n int) int {
		return n * n
	})
	fmt.Println("Squares:", squares)
	
	// Chunk into groups
	chunks := sliceutil.Chunk(numbers, {{chunkSize}})
	fmt.Println("Chunks:", chunks)
	
	// Remove duplicates
	unique := sliceutil.Unique(numbers)
	fmt.Println("Unique:", unique)
}