class URLParser {
  constructor(url) {
    this.url = new URL(url);
  }
  
  getProtocol() {
    return this.url.protocol.slice(0, -1);
  }
  
  getHost() {
    return this.url.host;
  }
  
  getPath() {
    return this.url.pathname;
  }
  
  getQueryParam(key) {
    return this.url.searchParams.get(key);
  }
  
  setQueryParam(key, value) {
    this.url.searchParams.set(key, value);
    return this;
  }
  
  removeQueryParam(key) {
    this.url.searchParams.delete(key);
    return this;
  }
  
  getAllQueryParams() {
    const params = {};
    this.url.searchParams.forEach((value, key) => {
      params[key] = value;
    });
    return params;
  }
  
  toString() {
    return this.url.toString();
  }
}

module.exports = URLParser;