#ifndef LINKED_LIST_H
#define LINKED_LIST_H

#include <stdlib.h>

typedef struct Node {
    int data;
    struct Node* next;
} Node;

typedef struct LinkedList {
    Node* head;
    int size;
} LinkedList;

LinkedList* list_create() {
    LinkedList* list = (LinkedList*)malloc(sizeof(LinkedList));
    if (list) {
        list->head = NULL;
        list->size = 0;
    }
    return list;
}

void list_insert_head(LinkedList* list, int data) {
    if (list == NULL) return;
    
    Node* new_node = (Node*)malloc(sizeof(Node));
    if (new_node) {
        new_node->data = data;
        new_node->next = list->head;
        list->head = new_node;
        list->size++;
    }
}

void list_insert_tail(LinkedList* list, int data) {
    if (list == NULL) return;
    
    Node* new_node = (Node*)malloc(sizeof(Node));
    if (new_node) {
        new_node->data = data;
        new_node->next = NULL;
        
        if (list->head == NULL) {
            list->head = new_node;
        } else {
            Node* current = list->head;
            while (current->next != NULL) {
                current = current->next;
            }
            current->next = new_node;
        }
        list->size++;
    }
}

int list_delete(LinkedList* list, int data) {
    if (list == NULL || list->head == NULL) return 0;
    
    if (list->head->data == data) {
        Node* temp = list->head;
        list->head = list->head->next;
        free(temp);
        list->size--;
        return 1;
    }
    
    Node* current = list->head;
    while (current->next != NULL) {
        if (current->next->data == data) {
            Node* temp = current->next;
            current->next = current->next->next;
            free(temp);
            list->size--;
            return 1;
        }
        current = current->next;
    }
    
    return 0;
}

int list_search(LinkedList* list, int data) {
    if (list == NULL) return 0;
    
    Node* current = list->head;
    while (current != NULL) {
        if (current->data == data) return 1;
        current = current->next;
    }
    return 0;
}

void list_free(LinkedList* list) {
    if (list == NULL) return;
    
    Node* current = list->head;
    while (current != NULL) {
        Node* temp = current;
        current = current->next;
        free(temp);
    }
    free(list);
}

#endif