from retry import retry
import requests


@retry(max_attempts={{maxAttempts}}, delay={{delay}}, backoff={{backoff}})
def fetch_data(url: str):
    response = requests.get(url)
    response.raise_for_status()
    return response.json()


try:
    data = fetch_data('{{url}}')
    print(data)
except Exception as e:
    print(f'Failed after retries: {e}')