from uuid_generator import UUIDGenerator

# Generate UUID v4
uuid_v4 = UUIDGenerator.v4()
print(f'UUID v4: {uuid_v4}')

# Generate UUID v1
uuid_v1 = UUIDGenerator.v1()
print(f'UUID v1: {uuid_v1}')

# Generate with version parameter
uuid_custom = UUIDGenerator.generate({{version}})
print(f'UUID {{version}}: {uuid_custom}')

# Validate
is_valid = UUIDGenerator.validate('{{uuidToValidate}}')
print(f'Valid: {is_valid}')

# Convert to hex
hex_uuid = UUIDGenerator.to_hex('{{uuidToConvert}}')
print(f'Hex: {hex_uuid}')