import uuid
from typing import Optional


class UUIDGenerator:
    @staticmethod
    def v1() -> str:
        """Generate UUID v1 (time-based)."""
        return str(uuid.uuid1())
    
    @staticmethod
    def v4() -> str:
        """Generate UUID v4 (random)."""
        return str(uuid.uuid4())
    
    @staticmethod
    def generate(version: int = {{version}}) -> str:
        """Generate UUID of specified version."""
        if version == 1:
            return UUIDGenerator.v1()
        elif version == 4:
            return UUIDGenerator.v4()
        else:
            raise ValueError(f"Unsupported UUID version: {version}")
    
    @staticmethod
    def validate(uuid_string: str) -> bool:
        """Validate UUID format."""
        try:
            uuid.UUID(uuid_string)
            return True
        except (ValueError, AttributeError):
            return False
    
    @staticmethod
    def to_hex(uuid_string: str) -> Optional[str]:
        """Convert UUID to hex format (without dashes)."""
        try:
            return uuid.UUID(uuid_string).hex
        except (ValueError, AttributeError):
            return None