import AsyncQueue from './AsyncQueue';

const queue = new AsyncQueue({{concurrency}});

const tasks = [
  () => fetch('{{url1}}').then(r => r.json()),
  () => fetch('{{url2}}').then(r => r.json()),
  () => fetch('{{url3}}').then(r => r.json()),
];

// Add tasks with priorities
const results = await Promise.all(
  tasks.map((task, i) => queue.add(task, i))
);

console.log('Results:', results);