import EventEmitter from './EventEmitter';

interface MyEvents {
  'user:login': { userId: string; email: string };
  'user:logout': { userId: string };
  'message:send': { text: string; timestamp: number };
}

const emitter = new EventEmitter<MyEvents>();

emitter.on('user:login', (data) => {
  console.log(`User ${data.userId} logged in with email ${data.email}`);
});

emitter.once('user:logout', (data) => {
  console.log(`User ${data.userId} logged out`);
});

emitter.emit('user:login', { userId: '{{userId}}', email: '{{email}}' });
emitter.emit('message:send', { text: '{{message}}', timestamp: Date.now() });