import PromisePool from './PromisePool';

const pool = new PromisePool({{concurrency}});

const urls = {{urls}};
urls.forEach(url => {
  pool.add(() => fetch(url).then(r => r.json()));
});

const { results, errors } = await pool.execute((completed, total) => {
  console.log(`Progress: ${completed}/${total}`);
});

console.log(`Completed: ${results.length} successful, ${errors.length} errors`);