use result_combinators::{ResultExt, combine_results};

// Error conversion
let res: Result<i32, String> = Err("error".to_string());
let converted: Result<i32, Box<dyn std::error::Error>> = res.map_err_into();

// Fallback value
let value = res.or_else_ok(|_| {{defaultValue}});

// Combine multiple results
let results = vec![Ok(1), Ok(2), Err("error".to_string())];
let combined = combine_results(results);