use option_utils::{OptionExt, unwrap_or_default, option_to_result};

let value: Option<i32> = Some({{value}});

// Use extension methods
let result = value
    .map_or_default(|v| v * 2)
    .filter_map(|v| if v > {{threshold}} { Some(v) } else { None });

// Convert to Result
let res: Result<i32, &str> = option_to_result(value, "No value");

// Default fallback
let defaulted = unwrap_or_default(value);