pub struct StringBuilder {
    buffer: String,
}

impl StringBuilder {
    pub fn new() -> Self {
        StringBuilder {
            buffer: String::new(),
        }
    }
    
    pub fn with_capacity(capacity: usize) -> Self {
        StringBuilder {
            buffer: String::with_capacity(capacity),
        }
    }
    
    pub fn append(&mut self, s: &str) -> &mut Self {
        self.buffer.push_str(s);
        self
    }
    
    pub fn append_char(&mut self, c: char) -> &mut Self {
        self.buffer.push(c);
        self
    }
    
    pub fn append_line(&mut self, s: &str) -> &mut Self {
        self.buffer.push_str(s);
        self.buffer.push('\n');
        self
    }
    
    pub fn append_format(&mut self, format: &str, args: &[&dyn std::fmt::Display]) -> &mut Self {
        // Simplified format - in real implementation, use format! macro
        self.buffer.push_str(&format!("{}", format));
        self
    }
    
    pub fn build(self) -> String {
        self.buffer
    }
    
    pub fn len(&self) -> usize {
        self.buffer.len()
    }
    
    pub fn clear(&mut self) {
        self.buffer.clear();
    }
}

impl Default for StringBuilder {
    fn default() -> Self {
        Self::new()
    }
}