use error_context::{ErrorContext, with_context};
use std::fs;

fn read_config(path: &str) -> Result<String, Box<dyn std::error::Error>> {
    fs::read_to_string(path)
        .context(format!("Failed to read config from {{path}}"))?;
    Ok("config content".to_string())
}

fn process_data(data: &str) -> Result<(), Box<dyn std::error::Error>> {
    // Some processing
    Ok(())
}

let result = read_config("{{configPath}}")
    .and_then(|content| process_data(&content).context("Failed to process data"));