import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

public class JsonParser {
    private static final Gson gson = new Gson();
    
    public static <T> T parse(String json, Class<T> clazz) throws JsonParseException {
        try {
            return gson.fromJson(json, clazz);
        } catch (JsonSyntaxException e) {
            throw new JsonParseException("Invalid JSON syntax: " + e.getMessage(), e);
        }
    }
    
    public static <T> T parse(String json, Type type) throws JsonParseException {
        try {
            return gson.fromJson(json, type);
        } catch (JsonSyntaxException e) {
            throw new JsonParseException("Invalid JSON syntax: " + e.getMessage(), e);
        }
    }
    
    public static Map<String, Object> parseToMap(String json) throws JsonParseException {
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        return parse(json, type);
    }
    
    public static String toJson(Object obj) {
        return gson.toJson(obj);
    }
    
    public static boolean isValid(String json) {
        try {
            gson.fromJson(json, Object.class);
            return true;
        } catch (JsonSyntaxException e) {
            return false;
        }
    }
    
    public static class JsonParseException extends Exception {
        public JsonParseException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}