import java.util.regex.Pattern;
import java.util.regex.Matcher;

public class EmailValidator {
    private static final Pattern EMAIL_PATTERN = Pattern.compile(
        "^[a-zA-Z0-9_+&*-]+(?:\\.[a-zA-Z0-9_+&*-]+)*@" +
        "(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,}$"
    );
    
    private static final String[] DISPOSABLE_DOMAINS = {
        "tempmail.com", "10minutemail.com", "guerrillamail.com"
    };
    
    public static boolean isValid(String email) {
        if (email == null || email.isEmpty()) {
            return false;
        }
        
        Matcher matcher = EMAIL_PATTERN.matcher(email);
        if (!matcher.matches()) {
            return false;
        }
        
        String[] parts = email.split("@");
        if (parts.length != 2) {
            return false;
        }
        
        String domain = parts[1].toLowerCase();
        
        if (domain.length() < 4) {
            return false;
        }
        
        if (!domain.contains(".")) {
            return false;
        }
        
        return true;
    }
    
    public static boolean isDisposable(String email) {
        if (!isValid(email)) {
            return false;
        }
        
        String domain = email.split("@")[1].toLowerCase();
        for (String disposable : DISPOSABLE_DOMAINS) {
            if (domain.equals(disposable)) {
                return true;
            }
        }
        return false;
    }
    
    public static String normalize(String email) {
        if (email == null) {
            return null;
        }
        return email.trim().toLowerCase();
    }
}