import java.util.regex.Pattern;

public class StringUtils {
    private static final Pattern EMAIL_PATTERN = 
        Pattern.compile("^[A-Za-z0-9+_.-]+@[A-Za-z0-9.-]+$");
    
    public static boolean isValidEmail(String email) {
        return email != null && EMAIL_PATTERN.matcher(email).matches();
    }
    
    public static String toCamelCase(String str) {
        if (str == null || str.isEmpty()) return str;
        
        String[] parts = str.split("[-_\\s]+");
        StringBuilder result = new StringBuilder(parts[0].toLowerCase());
        
        for (int i = 1; i < parts.length; i++) {
            if (!parts[i].isEmpty()) {
                result.append(Character.toUpperCase(parts[i].charAt(0)));
                result.append(parts[i].substring(1).toLowerCase());
            }
        }
        return result.toString();
    }
    
    public static String truncate(String str, int maxLength, String suffix) {
        if (str == null || str.length() <= maxLength) return str;
        return str.substring(0, maxLength - suffix.length()) + suffix;
    }
    
    public static String padLeft(String str, int length, char padChar) {
        if (str == null) str = "";
        if (str.length() >= length) return str;
        return String.valueOf(padChar).repeat(length - str.length()) + str;
    }
}