const LOG_LEVELS = {
  DEBUG: 0,
  INFO: 1,
  WARN: 2,
  ERROR: 3
};

class Logger {
  constructor(level = LOG_LEVELS.INFO, enabled = {{enabled}}) {
    this.level = level;
    this.enabled = enabled;
  }
  
  debug(...args) {
    if (this.enabled && this.level <= LOG_LEVELS.DEBUG) {
      console.log('[DEBUG]', ...args);
    }
  }
  
  info(...args) {
    if (this.enabled && this.level <= LOG_LEVELS.INFO) {
      console.info('[INFO]', ...args);
    }
  }
  
  warn(...args) {
    if (this.enabled && this.level <= LOG_LEVELS.WARN) {
      console.warn('[WARN]', ...args);
    }
  }
  
  error(...args) {
    if (this.enabled && this.level <= LOG_LEVELS.ERROR) {
      console.error('[ERROR]', ...args);
    }
  }
}

module.exports = Logger;