const debounce = require('./debounce');

// Debounce search input
const searchInput = document.getElementById('search');
const debouncedSearch = debounce((query) => {
  console.log('Searching for:', query);
  // API call here
}, {{delay}});

searchInput.addEventListener('input', (e) => {
  debouncedSearch(e.target.value);
});

// Immediate execution variant
const debouncedResize = debounce(() => {
  console.log('Window resized');
}, 300, true);

window.addEventListener('resize', debouncedResize);