# Java String Manipulation

> Common operations for working with strings: concatenation, splitting, searching, and formatting

**Language:** java (1.0+)

**Tags:** strings, text-processing, manipulation

## Description

Strings in Java are immutable objects that represent sequences of characters. The String class provides numerous methods for manipulation, searching, and formatting. Understanding these methods is essential for effective Java programming.

## Key Characteristics
- **Immutability**: Strings cannot be modified after creation
- **String Pool**: String literals are stored in a pool for reuse
- **StringBuilder/StringBuffer**: Mutable alternatives for frequent concatenation

## Common Operations
- **Concatenation**: Combining strings
- **Substring**: Extracting parts of strings
- **Search**: Finding characters or substrings
- **Replace**: Replacing characters or substrings
- **Split**: Breaking strings into arrays
- **Format**: Creating formatted strings
- **Case conversion**: Converting between upper/lower case

---
*Created: 2025-11-03*