# Java Switch Expressions

> Modern switch syntax that returns values and supports multiple patterns (Java 14+)

**Language:** java (14+)

**Tags:** switch, expressions, java14, control-flow

## Description

Switch expressions were introduced in Java 14 as a preview feature and became standard in Java 14. They provide a more concise syntax for switch statements and can return values, making code more readable and less error-prone.

## Key Features
- **Expression syntax**: Switch can return values
- **Arrow syntax**: `case label -> value` instead of `case label: break;`
- **Multiple labels**: `case A, B -> value`
- **No fall-through**: Each case is independent
- **Pattern matching**: Use with pattern matching (Java 17+)
- **Null handling**: Explicit null case handling

## Benefits
- **Less boilerplate**: No break statements needed
- **More readable**: Clear expression of intent
- **Safer**: No accidental fall-through
- **Exhaustive**: Compiler can check all cases covered
- **Functional style**: More expression-oriented

## Comparison with Switch Statements
- **Statements**: Execute code blocks, no return value
- **Expressions**: Return values, can be assigned
- **Arrow syntax**: Available in both, but more common in expressions

---
*Created: 2025-11-03*