# Understanding Java Abstract Classes

> Concept explanation of abstract classes that cannot be instantiated and may contain abstract methods

**Language:** java (1.0+)

**Tags:** abstract, oop, inheritance, concepts

## Description

Abstract classes in Java are classes that cannot be instantiated directly. They serve as base classes for other classes and can contain both abstract methods (without implementation) and concrete methods (with implementation).

## Key Concepts

### What is an Abstract Class?
- Declared with the `abstract` keyword
- Cannot be instantiated directly
- Can contain abstract methods (no body)
- Can contain concrete methods (with implementation)
- Can have constructors, fields, and both static and instance methods

### Abstract Methods
- Declared with `abstract` keyword
- Have no implementation (no body)
- Must be implemented by concrete subclasses
- Cannot be private, final, or static

### When to Use Abstract Classes
- When you want to share code among closely related classes
- When you have some common implementation but some methods need to be implemented by subclasses
- When you want to provide a template for subclasses
- For "is-a" relationships where some behavior is shared

### Abstract Class vs Interface
- **Abstract class**: Single inheritance, can have instance variables, various access modifiers, can have constructors
- **Interface**: Multiple inheritance, no instance variables (except constants), methods are public, no constructors
- Use abstract classes when you need shared implementation
- Use interfaces when you need to define contracts

## Benefits
- **Code reuse**: Share common implementation
- **Template method pattern**: Define algorithm skeleton
- **Forced implementation**: Require subclasses to implement specific methods
- **Flexibility**: Mix abstract and concrete methods

## Best Practices
- Use abstract classes for "is-a" relationships
- Provide meaningful default implementations when possible
- Keep abstract methods focused and specific
- Document expected behavior
- Consider using interfaces for more flexibility

---
*Created: 2025-11-03*