# Minestom Creating Custom Commands

> Create and register custom commands with argument parsing and syntax definitions

**Language:** java (17+)

**Tags:** minestom, commands, minecraft, server

## Description

Minestom provides a powerful command system that allows you to create custom commands with complex argument parsing, auto-completion, and multiple syntaxes. Commands extend the Command class and use ArgumentType to define parameters.

## Key Features
- **Multiple syntaxes**: Define different command variations
- **Argument types**: String, Integer, Double, Boolean, Entity, Player, etc.
- **Auto-completion**: Built-in tab completion support
- **Conditional execution**: Check permissions and sender types
- **Command callbacks**: Handle command execution with lambdas

## Common Argument Types
- `ArgumentType.String()` - Text input
- `ArgumentType.Integer()` - Whole numbers
- `ArgumentType.Double()` - Decimal numbers
- `ArgumentType.Boolean()` - True/false values
- `ArgumentType.Word()` - Single word
- `ArgumentType.Entity()` - Entity selector
- `ArgumentType.Player()` - Player selector

---
*Created: 2025-11-03*