# Understanding Minestom Tags System

> Concept explanation of how Tags provide type-safe custom data storage using NBT

**Language:** java (17+)

**Tags:** minestom, tags, nbt, data, concepts

## Description

Minestom's Tags system provides a type-safe way to store custom data on entities, items, blocks, and other objects using NBT (Named Binary Tag) format. Tags are efficient, persistent, and allow you to attach custom properties without modifying core classes.

## Key Concepts

### What are Tags?
Tags are typed key-value pairs that can be attached to various objects:
- **Entities**: Store custom entity properties
- **Items**: Store item metadata and custom data
- **Blocks**: Store block state and custom properties
- **Other objects**: Any object implementing TagReadable/TagWritable

### NBT Format
Tags use NBT (Named Binary Tag) format, which is:
- **Efficient**: Compact binary representation
- **Persistent**: Can be saved to disk
- **Type-safe**: Strong typing prevents errors
- **Compatible**: Works with Minecraft's NBT system

### Tag Types
- **String**: Text data
- **Integer**: Whole numbers
- **Double**: Decimal numbers
- **Float**: Floating point numbers
- **Boolean**: True/false values
- **Byte/Short/Long**: Various integer sizes
- **Compound**: Nested tag structures
- **List**: Arrays of tags

### Tag Interfaces
- **TagReadable**: Objects that can read tags
- **TagWritable**: Objects that can write tags
- Most entities, items, and blocks implement both

### Tag Lifecycle
1. **Create tag**: Define tag with type and name
2. **Set tag**: Store value on object
3. **Get tag**: Retrieve value from object
4. **Check tag**: Verify tag exists
5. **Remove tag**: Delete tag from object
6. **Serialize**: Tags are automatically serialized with objects

### Persistence
- Tags are automatically saved with entities/items
- Survive server restarts (if configured)
- Can be exported/imported
- Compatible with Minecraft's save format

## Use Cases
- **Entity properties**: Store custom entity data (health, level, etc.)
- **Item metadata**: Store item-specific data (durability, enchantments)
- **Block state**: Store custom block properties
- **Player data**: Store player-specific information
- **Game state**: Track game-specific data

## Benefits
- **Type safety**: Compile-time type checking
- **Efficiency**: Optimized NBT storage
- **Persistence**: Automatic saving/loading
- **Flexibility**: Store any type of data
- **Compatibility**: Works with Minecraft's data format

## Best Practices
- Use descriptive tag names (namespace them: "plugin:tag_name")
- Store tags as static final fields for reuse
- Check for null when reading tags
- Use appropriate types (don't store numbers as strings)
- Clean up unused tags
- Document tag usage in your code
- Consider tag size (large compounds can be expensive)

---
*Created: 2025-11-03*