# Java Regular Expressions

> Pattern matching and text manipulation using regex patterns with Pattern and Matcher classes

**Language:** java (1.4+)

**Tags:** regex, pattern-matching, validation, text-processing

## Description

Java's regular expression support through the `java.util.regex` package provides powerful pattern matching capabilities. Regular expressions are useful for validation, searching, replacing, and parsing text.

## Key Classes
- **Pattern**: Compiled representation of a regular expression
- **Matcher**: Engine that performs match operations on a character sequence
- **PatternSyntaxException**: Unchecked exception indicating syntax error in regex

## Common Patterns
- **Email validation**: `^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$`
- **Phone numbers**: `^\+?[1-9]\d{1,14}$`
- **URLs**: `^https?://[\w\-.]+(\.[\w\-.]+)*([\w\-\.,@?^=%&:/~+#]*)?$`
- **Dates**: `^\d{4}-\d{2}-\d{2}$`

## Common Operations
- Match: Check if pattern matches entire string
- Find: Search for pattern in string
- Replace: Replace matches with new text
- Split: Split string by pattern

---
*Created: 2025-11-03*