# Java Exception Handling

> Error handling mechanisms using try-catch blocks, checked and unchecked exceptions

**Language:** java (1.0+)

**Tags:** exceptions, error-handling, try-catch

## Description

Java's exception handling mechanism allows programs to handle errors gracefully. Exceptions are objects that represent exceptional conditions and can be caught and handled using try-catch blocks.

## Exception Types
- **Checked exceptions**: Must be declared or caught (e.g., IOException)
- **Unchecked exceptions**: Runtime exceptions (e.g., NullPointerException)
- **Errors**: Serious problems (e.g., OutOfMemoryError)

## Exception Handling
- **try-catch**: Catch and handle exceptions
- **finally**: Code that always executes
- **try-with-resources**: Automatic resource management
- **throws**: Declare exceptions that may be thrown
- **throw**: Explicitly throw an exception

---
*Created: 2025-11-03*