# Understanding Java Polymorphism

> Concept explanation of how objects can take multiple forms through inheritance and interfaces

**Language:** java (1.0+)

**Tags:** polymorphism, oop, inheritance, concepts

## Description

Polymorphism is one of the four fundamental principles of object-oriented programming. It allows objects of different types to be treated through the same interface, enabling code to work with objects of multiple types.

## Key Concepts

### What is Polymorphism?
- **Poly** = many, **morph** = forms
- Same interface, different implementations
- Ability of an object to take multiple forms
- Enables "write once, use many" approach

### Types of Polymorphism

#### Compile-time Polymorphism (Method Overloading)
- Multiple methods with same name but different parameters
- Resolved at compile time
- Based on method signature (number, type, order of parameters)
- Return type alone cannot distinguish overloaded methods

#### Runtime Polymorphism (Method Overriding)
- Subclass provides specific implementation of parent method
- Resolved at runtime based on actual object type
- Requires inheritance or interface implementation
- Enables dynamic method dispatch

### Method Binding
- **Static binding**: Method call resolved at compile time (overloading, static methods, final methods)
- **Dynamic binding**: Method call resolved at runtime (overriding instance methods)

### Virtual Method Invocation
- Java uses virtual method invocation for overridden methods
- The JVM calls the method based on the actual object type, not the reference type
- This is why overriding works - the runtime type determines which method executes

## Benefits
- **Flexibility**: Code can work with multiple types
- **Extensibility**: Add new types without modifying existing code
- **Maintainability**: Centralize common logic
- **Code reuse**: Share interfaces while allowing different implementations

## Best Practices
- Use interfaces or abstract classes for polymorphic behavior
- Favor composition over inheritance when appropriate
- Use @Override annotation for clarity
- Keep method signatures consistent in polymorphic hierarchies
- Document expected behavior in base classes/interfaces

## Common Patterns
- **Strategy pattern**: Different algorithms at runtime
- **Template method**: Define algorithm skeleton, let subclasses fill steps
- **Factory pattern**: Create objects without specifying exact class
- **Dependency injection**: Inject implementations through interfaces

---
*Created: 2025-11-03*