# Java Sealed Classes

> Restrict which classes can extend a class or implement an interface (Java 17+)

**Language:** java (17+)

**Tags:** sealed, inheritance, java17, pattern-matching

## Description

Sealed classes and interfaces restrict which other classes or interfaces may extend or implement them. This provides more control over inheritance hierarchies and enables exhaustive pattern matching.

## Key Features
- **Sealed classes**: Control which classes can extend them
- **Sealed interfaces**: Control which classes can implement them
- **Permits clause**: Explicitly lists allowed subclasses/implementations
- **Non-sealed**: Allows a subclass to be extended by any class
- **Final**: Prevents further inheritance

## Benefits
- **Controlled inheritance**: Prevent unauthorized subclassing
- **Exhaustive pattern matching**: Compiler can verify all cases are handled
- **Better design**: Enforce design constraints at language level
- **Documentation**: Make inheritance hierarchy explicit

## Use Cases
- Modeling algebraic data types
- State machines with known states
- API design with controlled extension points
- Pattern matching with exhaustive checking

---
*Created: 2025-11-03*