# Minestom Entity Tags and Custom Data

> Store and retrieve custom data on entities using the Tags system

**Language:** java (17+)

**Tags:** minestom, entities, tags, nbt, data

## Description

Minestom's Tags system allows you to attach custom data to entities, items, and blocks using NBT (Named Binary Tag) format. Tags are type-safe and efficient for storing custom properties and state.

## Key Features
- **Type-safe**: Strongly typed tag storage
- **Persistent**: Data survives server restarts (if configured)
- **Efficient**: Uses NBT format for serialization
- **Multiple types**: String, Integer, Double, Boolean, Compound, etc.
- **Entity-specific**: Tags are attached to specific entities

## Common Use Cases
- Storing custom entity properties
- Tracking entity state
- Persisting entity data
- Custom metadata
- Plugin-specific data storage

---
*Created: 2025-11-03*