# Java Streams API

> Functional-style operations on collections for data processing and transformation

**Language:** java (8+)

**Tags:** streams, functional, collections, java8

## Description

The Streams API in Java provides a declarative way to process collections of data. It enables functional-style operations like map, filter, reduce, and supports parallel processing.

## Key Concepts
- **Stream**: A sequence of elements supporting sequential and parallel aggregate operations
- **Intermediate operations**: Return a stream (e.g., filter, map, sorted)
- **Terminal operations**: Produce a result (e.g., collect, forEach, reduce)
- **Lazy evaluation**: Intermediate operations are lazy and only executed when a terminal operation is invoked
- **Parallel streams**: Enable automatic parallelization using `parallelStream()`

## Common Operations
- **Filter**: Select elements matching a predicate
- **Map**: Transform elements to another type
- **Reduce**: Combine elements into a single value
- **Collect**: Accumulate elements into collections
- **FlatMap**: Flatten nested structures

---
*Created: 2025-11-03*