# Java Text Blocks

> Multi-line string literals with improved readability (Java 15+)

**Language:** java (15+)

**Tags:** text-blocks, strings, multiline, java15

## Description

Text blocks are multi-line string literals that make it easier to work with strings that span multiple lines. They were introduced as a preview feature in Java 13 and became standard in Java 15.

## Key Features
- **Multi-line strings**: Write strings across multiple lines naturally
- **Automatic formatting**: Preserves indentation and whitespace
- **Escape sequences**: Support for escape sequences
- **Interpolation**: Can use expressions (future feature)

## Syntax
- Start with `"""` (three double quotes)
- Content on the next line
- End with `"""`
- Indentation is relative to the closing delimiter

## Use Cases
- SQL queries
- JSON/XML strings
- HTML templates
- Multi-line messages
- Code generation
- Configuration strings

---
*Created: 2025-11-03*