# Java Generics

> Type-safe collections and parameterized types for compile-time type checking

**Language:** java (5+)

**Tags:** generics, type-safety, collections

## Description

Generics in Java enable you to write type-safe code that works with different types. They provide compile-time type checking and eliminate the need for explicit type casting.

## Key Concepts
- **Type parameters**: Placeholders like `<T>`, `<E>`, `<K, V>`
- **Bounded types**: Restrict type parameters with `extends` or `super`
- **Wildcards**: `?`, `? extends Type`, `? super Type`
- **Type erasure**: Generics are erased at runtime, only exist at compile time
- **Raw types**: Non-parameterized generic types (not recommended)

## Common Use Cases
- Type-safe collections
- Generic methods and classes
- Parameterized interfaces
- Bounded type parameters for constraints

---
*Created: 2025-11-03*