# Java Pattern Matching

> Simplify instanceof checks and switch statements with pattern matching (Java 16+)

**Language:** java (16+)

**Tags:** pattern-matching, switch, instanceof, java16

## Description

Pattern matching simplifies common coding patterns by combining type checking and casting into a single operation. It reduces boilerplate code and makes programs more readable and less error-prone.

## Key Features
- **Pattern matching for instanceof**: Automatically casts after type check
- **Pattern matching for switch**: Use patterns in switch expressions
- **Type patterns**: Match against types and bind variables
- **Guarded patterns**: Add conditions to pattern matches

## Benefits
- **Less boilerplate**: No explicit casting needed
- **Safer code**: Compiler ensures type safety
- **More readable**: Clear intent in code
- **Exhaustiveness checking**: Compiler can verify all cases handled

## Evolution
- **Java 14**: Pattern matching for instanceof (preview)
- **Java 16**: Pattern matching for instanceof (standard)
- **Java 17**: Pattern matching for switch (preview)
- **Java 19**: Pattern matching for switch (standard)
- **Java 21**: Record patterns, pattern matching improvements

---
*Created: 2025-11-03*