# Java Collections Framework

> Core data structures and algorithms for storing and manipulating groups of objects

**Language:** java (1.2+)

**Tags:** collections, data-structures, lists, maps, sets

## Description

The Java Collections Framework provides a unified architecture for representing and manipulating collections. It includes interfaces, implementations, and algorithms for common data structures.

## Main Interfaces
- **Collection**: Root interface for all collections
- **List**: Ordered collection with duplicates allowed
- **Set**: Collection with no duplicates
- **Map**: Key-value pairs (not technically a Collection)
- **Queue**: Elements processed in FIFO order
- **Deque**: Double-ended queue

## Common Implementations
- **ArrayList**: Dynamic array implementation of List
- **LinkedList**: Doubly-linked list implementation
- **HashMap**: Hash table implementation of Map
- **HashSet**: Hash table implementation of Set
- **TreeMap**: Red-black tree implementation (sorted)
- **TreeSet**: Red-black tree implementation (sorted)

---
*Created: 2025-11-03*