# Understanding Minestom Instances

> Concept explanation of how instances represent separate game worlds in Minestom

**Language:** java (17+)

**Tags:** minestom, instances, worlds, concepts

## Description

Instances in Minestom represent separate game worlds that can contain their own blocks, entities, and players. Each instance is independent, allowing you to create multiple worlds, dimensions, or game modes with different configurations.

## Key Concepts

### What is an Instance?
An instance is a container for:
- **Blocks**: The world's terrain and structures
- **Entities**: Players, mobs, items, etc.
- **Chunks**: Loaded regions of the world
- **Configuration**: Time, difficulty, game rules

### Instance Types
- **InstanceContainer**: Standard game world
- **SharedInstance**: Shared between multiple servers (advanced)
- **AnvilInstance**: Loads from Anvil world files
- **Custom instances**: Extend Instance for custom behavior

### Instance Properties
Each instance can have:
- **Time**: World time (0-24000)
- **Time rate**: How fast time passes
- **Difficulty**: Peaceful, Easy, Normal, Hard
- **Dimension**: Overworld, Nether, End
- **Chunk loader**: How chunks are loaded/saved
- **Spawn point**: Default spawn location

### Player Management
Players can be in one instance at a time:
- **setInstance()**: Move player to instance
- **getInstance()**: Get player's current instance
- **getPlayers()**: Get all players in instance
- **Instance-specific**: Players see only their instance

### Chunk Management
Instances manage chunks:
- **Chunk loading**: Load chunks as players move
- **Chunk generation**: Generate new chunks
- **Chunk saving**: Save chunks to disk
- **Chunk unloading**: Unload distant chunks

### Block and Entity Management
Instances contain:
- **Blocks**: Set/get blocks at positions
- **Entities**: Spawn/remove entities
- **Region operations**: Set blocks in regions
- **Query operations**: Find blocks/entities

### Instance Lifecycle
1. **Creation**: Instance is created
2. **Configuration**: Set properties (time, difficulty, etc.)
3. **Chunk loading**: Load or generate chunks
4. **Active**: Players can join and play
5. **Cleanup**: Unload chunks, save data
6. **Destruction**: Instance is removed

## Use Cases
- **Multiple worlds**: Different game worlds
- **Lobby system**: Separate lobby and game instances
- **Dimensions**: Overworld, Nether, End
- **Game modes**: Different instances for different game modes
- **Testing**: Isolated test worlds
- **Custom generation**: Procedurally generated worlds

## Benefits
- **Isolation**: Instances are independent
- **Flexibility**: Different configurations per instance
- **Performance**: Only load what's needed
- **Scalability**: Create many instances
- **Modularity**: Easy to manage multiple worlds

## Best Practices
- Create instances at startup
- Configure instances before use
- Use appropriate chunk loaders
- Clean up unused instances
- Monitor instance performance
- Use instance-specific event listeners
- Save important instance data
- Consider memory usage with many instances

---
*Created: 2025-11-03*