# Java Annotations

> Metadata added to code elements using @Annotation syntax for frameworks and tools

**Language:** java (5+)

**Tags:** annotations, metadata, reflection

## Description

Annotations in Java provide metadata about program elements. They can be used by compilers, frameworks, and runtime environments to provide additional information or processing instructions.

## Built-in Annotations
- **@Override**: Indicates method overrides a superclass method
- **@Deprecated**: Marks element as deprecated
- **@SuppressWarnings**: Suppresses compiler warnings
- **@FunctionalInterface**: Marks interface as functional interface

## Common Framework Annotations
- **@Entity, @Table**: JPA/Hibernate entity mapping
- **@Autowired, @Component**: Spring dependency injection
- **@Test, @BeforeEach**: JUnit testing annotations
- **@RequestMapping**: Spring MVC routing

## Custom Annotations
- Define with @interface
- Can have parameters
- Can have retention policies
- Can target specific elements

---
*Created: 2025-11-03*