# Java Singleton Pattern

> Creational pattern ensuring only one instance of a class exists

**Language:** java (1.0+)

**Tags:** singleton, design-pattern, creational

## Description

The Singleton pattern ensures that a class has only one instance and provides a global point of access to it. It's useful when exactly one object is needed to coordinate actions across the system.

## Key Characteristics
- **Single instance**: Only one instance of the class exists
- **Global access**: Provides a global point of access
- **Lazy initialization**: Instance created when first needed (optional)
- **Thread safety**: Must be safe in multithreaded environments

## Implementation Approaches
- **Eager initialization**: Instance created at class loading time
- **Lazy initialization**: Instance created on first access
- **Double-checked locking**: Thread-safe lazy initialization
- **Bill Pugh solution**: Uses inner static class (recommended)
- **Enum singleton**: Simplest and most thread-safe

## When to Use
- Need exactly one instance of a class
- Global access point needed
- Resource management (database connections, file systems)
- Logging, configuration, caching

## Thread Safety Considerations
- Simple lazy initialization is NOT thread-safe
- Use synchronization or double-checked locking
- Enum singleton is inherently thread-safe
- Bill Pugh solution is thread-safe without synchronization overhead

---
*Created: 2025-11-03*