# Java Date and Time API

> Modern date and time handling using java.time package (LocalDate, LocalTime, LocalDateTime, ZonedDateTime)

**Language:** java (8+)

**Tags:** datetime, java8, time, date

## Description

Java 8 introduced the new Date and Time API in the `java.time` package, providing a comprehensive and immutable date-time API. It replaces the problematic `java.util.Date` and `Calendar` classes.

## Key Classes
- **LocalDate**: Date without time (year-month-day)
- **LocalTime**: Time without date (hour-minute-second)
- **LocalDateTime**: Date and time without timezone
- **ZonedDateTime**: Date and time with timezone
- **Instant**: Point in time (Unix timestamp)
- **Duration**: Time-based amount (hours, minutes, seconds)
- **Period**: Date-based amount (years, months, days)

## Common Operations
- Create dates and times
- Format and parse dates
- Calculate differences
- Add/subtract time periods
- Convert between timezones

---
*Created: 2025-11-03*