# Understanding Minestom Commands

> Concept explanation of Minestom's command system for creating custom server commands

**Language:** java (17+)

**Tags:** minestom, commands, concepts, minecraft

## Description

Minestom's command system provides a powerful and flexible way to create custom commands for your Minecraft server. Unlike traditional command systems, Minestom's approach allows for complex argument parsing, automatic tab completion, and multiple command syntaxes.

## Key Concepts

### Command Structure
- **Command class**: All commands extend the `Command` base class
- **Syntaxes**: A single command can have multiple valid syntaxes
- **Arguments**: Commands accept typed arguments (String, Integer, Double, Entity, etc.)
- **Callbacks**: Command execution is handled through lambda expressions or method references

### Argument Types
- **String**: Text input (can be single word or quoted string)
- **Word**: Single word (no spaces)
- **Integer/Double**: Numeric values with optional min/max constraints
- **Boolean**: True/false values
- **Entity**: Entity selectors (players, mobs, etc.)
- **Player**: Player-specific selectors
- **Block**: Block position selectors

### Command Execution Flow
1. Player types command with arguments
2. Minestom parses arguments based on defined syntaxes
3. Matches arguments to registered syntax
4. Validates argument types and constraints
5. Executes callback with parsed context
6. Returns result or error message

### Multiple Syntaxes
A single command can have multiple valid syntaxes, allowing flexibility:
- `/command <required>` - Required argument
- `/command [optional]` - Optional argument
- `/command <arg1> <arg2>` - Multiple arguments
- `/command <arg1> [arg2] [arg3]` - Mix of required and optional

### Auto-completion
- Tab completion is automatically provided for all argument types
- Word arguments can specify valid options for completion
- Entity selectors provide entity lists
- Block selectors provide block suggestions

### Conditions
- Commands can have conditions that check if execution is allowed
- Common conditions: player-only commands, permission checks, instance checks
- Conditions run before syntax matching

## Benefits
- **Type safety**: Strongly typed arguments prevent errors
- **Flexibility**: Multiple syntaxes for one command
- **User-friendly**: Automatic tab completion
- **Powerful**: Complex argument parsing with minimal code
- **Maintainable**: Clear separation of syntax and logic

## Best Practices
- Use descriptive argument names
- Provide clear error messages
- Use conditions for permission checks
- Support both player and console execution when appropriate
- Document command syntaxes for users
- Use appropriate argument types (don't use String for everything)

---
*Created: 2025-11-03*