# Java Optional Class

> Container object that may or may not contain a non-null value to avoid NullPointerException

**Language:** java (8+)

**Tags:** optional, null-safety, java8, functional

## Description

The Optional class was introduced in Java 8 to provide a better way to handle potentially null values. It encourages explicit null handling and reduces the risk of NullPointerException.

## Key Principles
- **Never null**: Optional itself should never be null
- **Empty or present**: An Optional either contains a value or is empty
- **Functional operations**: Provides map, filter, flatMap operations
- **OrElse methods**: Provide fallback values

## Best Practices
- Use Optional for return types, not for fields or parameters
- Avoid nesting Optionals (Optional<Optional<T>>)
- Don't use Optional.get() without checking isPresent()
- Prefer orElse() and orElseGet() over get()
- Use Optional.empty() and Optional.of() appropriately

---
*Created: 2025-11-03*