# Java File I/O

> Reading from and writing to files using various I/O classes and streams

**Language:** java (1.0+)

**Tags:** file-io, nio, streams, files

## Description

Java provides multiple ways to read and write files, from the classic FileInputStream/FileOutputStream to modern NIO.2 Path API. Understanding different approaches helps choose the right tool for each task.

## Approaches
- **Classic I/O**: FileInputStream, FileOutputStream, FileReader, FileWriter
- **Buffered I/O**: BufferedInputStream, BufferedWriter for better performance
- **NIO.2**: Path, Files, Channels for modern file operations
- **Try-with-resources**: Automatic resource management

## Common Operations
- Reading text files line by line
- Writing text to files
- Reading binary files
- Copying and moving files
- Directory operations

---
*Created: 2025-11-03*