{# This is a comment - it won't be rendered #}

# Welcome to {{ site_name }}

This is regular content outside any block.

{% block header %}
## Default Header
This header can be overridden in child templates.
{% endblock %}

---

{% if user.is_authenticated %}
Hello, **{{ user.name }}**! You are logged in.

{% if user.is_admin %}
You have administrative privileges.
{% elif user.is_moderator %}
You have moderator privileges.
{% else %}
You are a regular user.
{% endif %}

{% else %}
Welcome, guest! Please log in to continue.
{% endif %}

---

## User Statistics

{% set total_users = 150 %}
{% set active_users = 98 %}

Total users: {{ total_users }}  
Active users: {{ active_users }}

{% with completion_rate = (active_users / total_users * 100) | round(2) %}
Completion rate: {{ completion_rate }}%
{% endwith %}

---

## Available Features

{% for feature in features %}
- **{{ feature.name }}**: {{ feature.description }}
  {% if feature.is_new %}
  *🎉 NEW!*
  {% endif %}
{% endfor %}

---

{% macro render_badge(label, color="blue") %}
<span style="color: {{ color }}; font-weight: bold;">[{{ label }}]</span>
{% endmacro %}

## Product List

{% for product in products %}
### {{ product.name }} {{ render_badge(product.status, "green") }}

Price: ${{ product.price }}

{% if loop.index > 3 %}
{% break %}
{% endif %}
{% endfor %}

---

{% filter upper %}
This entire section will be converted to uppercase.
{% endfilter %}

---

{% raw %}
This section is raw: {{ variable }} won't be processed.
You can safely show Jinja syntax here: {% for item in items %}
{% endraw %}

---

{% autoescape true %}
User input (escaped): {{ user_input }}
{% endautoescape %}

---

{% call(item) render_list(items) %}
Processing: {{ item }}
{% endcall %}

---

## Footer Content

{% block footer %}
© 2024 {{ site_name }}. All rights reserved.
{% endblock footer %}

This is the final line of regular content.