package com.example.minestom;

import net.minestom.server.MinecraftServer;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.builder.Command;
import net.minestom.server.command.builder.arguments.ArgumentType;

public class CommandManager {
    
    public static void registerCommands(GameOfLifeServer server) {
        Command startCommand = new Command("start");
        startCommand.setDefaultExecutor((sender, context) -> {
            if (!(sender instanceof CommandSender)) return;
            server.startSimulation();
            sender.sendMessage("§aStarted Game of Life simulation!");
        });
        
        Command stopCommand = new Command("stop");
        stopCommand.setDefaultExecutor((sender, context) -> {
            if (!(sender instanceof CommandSender)) return;
            server.stopSimulation();
            sender.sendMessage("§cStopped Game of Life simulation!");
        });
        
        Command clearCommand = new Command("clear");
        clearCommand.setDefaultExecutor((sender, context) -> {
            if (!(sender instanceof CommandSender)) return;
            if (server.isRunning()) {
                sender.sendMessage("§cCannot clear while simulation is running!");
                return;
            }
            
            for (int x = 0; x < GameOfLifeServer.GRID_SIZE; x++) {
                for (int z = 0; z < GameOfLifeServer.GRID_SIZE; z++) {
                    server.grid[x][z] = false;
                    server.updateBlock(x, z);
                }
            }
            sender.sendMessage("§aGrid cleared!");
        });
        
        MinecraftServer.getCommandManager().register(startCommand);
        MinecraftServer.getCommandManager().register(stopCommand);
        MinecraftServer.getCommandManager().register(clearCommand);
    }
}