#!/usr/bin/env python3
"""
Basic Python List Comprehension Examples

This module demonstrates common list comprehension patterns in Python.
"""

# Example 1: Basic list comprehension
# Create a list of squares for numbers 0-9
squares = [x**2 for x in range(10)]

# Example 2: List comprehension with condition
# Create a list of even numbers from 0-19
evens = [x for x in range(20) if x % 2 == 0]

# Example 3: List comprehension with transformation
# Convert temperatures from Celsius to Fahrenheit
celsius_temps = [0, 10, 20, 30, 40]
fahrenheit_temps = [(temp * 9/5) + 32 for temp in celsius_temps]

# Example 4: Nested list comprehension
# Create a multiplication table (10x10)
multiplication_table = [[i * j for j in range(1, 11)] for i in range(1, 11)]

# Example 5: List comprehension with multiple conditions
# Find numbers divisible by 2 and 3 from 0-49
numbers = [x for x in range(50) if x % 2 == 0 and x % 3 == 0]

# Example 6: List comprehension with function
# Convert strings to uppercase
greetings = ['hello', 'world', 'python', 'list', 'comprehension']
uppercase_greetings = [greeting.upper() for greeting in greetings]

# Example 7: List comprehension with if-else
# Categorize numbers as even or odd
number_categories = ['even' if x % 2 == 0 else 'odd' for x in range(10)]

# Example 8: List comprehension with dictionary
# Extract keys from a dictionary
person = {'name': 'Alice', 'age': 30, 'city': 'New York'}
keys = [key for key in person]

# Example 9: List comprehension with set
# Remove duplicates from a list
numbers_with_duplicates = [1, 2, 2, 3, 4, 4, 5, 5, 5]
unique_numbers = list({x for x in numbers_with_duplicates})

# Example 10: List comprehension with enumerate
# Create a list of tuples with index and value
indexed_values = [(index, value) for index, value in enumerate(['a', 'b', 'c', 'd'])]

if __name__ == '__main__':
    print('Squares:', squares)
    print('Evens:', evens)
    print('Fahrenheit Temps:', fahrenheit_temps)
    print('Multiplication Table (first 3 rows):', multiplication_table[:3])
    print('Numbers divisible by 2 and 3:', numbers)
    print('Uppercase Greetings:', uppercase_greetings)
    print('Number Categories:', number_categories)
    print('Dictionary Keys:', keys)
    print('Unique Numbers:', unique_numbers)
    print('Indexed Values:', indexed_values)